
----------------------------------------------------------------
-- 
-- Copyright (c) 1995 by Altera Corporation.  All rights reserved.      
--
-- FILENAME     :    alt_vtl.cmp
-- FILE CONTENTS:    VITAL Component Package (2.2b)
-- DATE CREATED :    Fri Feb 17 15:54:24 1995
-- 
-- LIBRARY      :    alt_vtl
-- DATE ENTERED :    Wed Jan 25 09:45:07 1995
-- REVISION     :    1.0
-- TIME SCALE   :    1 ns
-- LOGIC SYSTEM :    IEEE-1164
-- NOTES        :    
-- HISTORY      :
-- 
----------------------------------------------------------------

library IEEE;
use IEEE.STD_LOGIC_1164.all;

library VITAL;
use VITAL.VITAL_Timing.all;

package VCOMPONENTS is

constant DefaultTimingChecksOn : Boolean := True;
constant DefaultXGenerationOn : Boolean := False;

----- Component AND1 -----
component AND1
   generic(
      TimingChecksOn: Boolean := DefaultTimingChecksOn;
      XGenerationOn: Boolean := DefaultXGenerationOn;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC);
end component;


----- Component AND2 -----
component AND2
   generic(
      TimingChecksOn: Boolean := DefaultTimingChecksOn;
      XGenerationOn: Boolean := DefaultXGenerationOn;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN2_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN2                       :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC;
      IN2                            :	in    STD_LOGIC);
end component;


----- Component AND3 -----
component AND3
   generic(
      TimingChecksOn: Boolean := DefaultTimingChecksOn;
      XGenerationOn: Boolean := DefaultXGenerationOn;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN2_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN3_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN2                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN3                       :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC;
      IN2                            :	in    STD_LOGIC;
      IN3                            :	in    STD_LOGIC);
end component;


----- Component AND4 -----
component AND4
   generic(
      TimingChecksOn: Boolean := DefaultTimingChecksOn;
      XGenerationOn: Boolean := DefaultXGenerationOn;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN2_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN3_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN4_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN2                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN3                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN4                       :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC;
      IN2                            :	in    STD_LOGIC;
      IN3                            :	in    STD_LOGIC;
      IN4                            :	in    STD_LOGIC);
end component;


----- Component AND5 -----
component AND5
   generic(
      TimingChecksOn: Boolean := DefaultTimingChecksOn;
      XGenerationOn: Boolean := DefaultXGenerationOn;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN2_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN3_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN4_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN5_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN2                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN3                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN4                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN5                       :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC;
      IN2                            :	in    STD_LOGIC;
      IN3                            :	in    STD_LOGIC;
      IN4                            :	in    STD_LOGIC;
      IN5                            :	in    STD_LOGIC);
end component;


----- Component AND6 -----
component AND6
   generic(
      TimingChecksOn: Boolean := DefaultTimingChecksOn;
      XGenerationOn: Boolean := DefaultXGenerationOn;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN2_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN3_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN4_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN5_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN6_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN2                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN3                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN4                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN5                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN6                       :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC;
      IN2                            :	in    STD_LOGIC;
      IN3                            :	in    STD_LOGIC;
      IN4                            :	in    STD_LOGIC;
      IN5                            :	in    STD_LOGIC;
      IN6                            :	in    STD_LOGIC);
end component;


----- Component AND7 -----
component AND7
   generic(
      TimingChecksOn: Boolean := DefaultTimingChecksOn;
      XGenerationOn: Boolean := DefaultXGenerationOn;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN2_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN3_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN4_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN5_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN6_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN7_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN2                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN3                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN4                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN5                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN6                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN7                       :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC;
      IN2                            :	in    STD_LOGIC;
      IN3                            :	in    STD_LOGIC;
      IN4                            :	in    STD_LOGIC;
      IN5                            :	in    STD_LOGIC;
      IN6                            :	in    STD_LOGIC;
      IN7                            :	in    STD_LOGIC);
end component;


----- Component AND8 -----
component AND8
   generic(
      TimingChecksOn: Boolean := DefaultTimingChecksOn;
      XGenerationOn: Boolean := DefaultXGenerationOn;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN2_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN3_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN4_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN5_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN6_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN7_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN8_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN2                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN3                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN4                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN5                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN6                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN7                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN8                       :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC;
      IN2                            :	in    STD_LOGIC;
      IN3                            :	in    STD_LOGIC;
      IN4                            :	in    STD_LOGIC;
      IN5                            :	in    STD_LOGIC;
      IN6                            :	in    STD_LOGIC;
      IN7                            :	in    STD_LOGIC;
      IN8                            :	in    STD_LOGIC);
end component;


----- Component AND9 -----
component AND9
   generic(
      TimingChecksOn: Boolean := DefaultTimingChecksOn;
      XGenerationOn: Boolean := DefaultXGenerationOn;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN2_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN3_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN4_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN5_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN6_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN7_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN8_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN9_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN2                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN3                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN4                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN5                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN6                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN7                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN8                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN9                       :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC;
      IN2                            :	in    STD_LOGIC;
      IN3                            :	in    STD_LOGIC;
      IN4                            :	in    STD_LOGIC;
      IN5                            :	in    STD_LOGIC;
      IN6                            :	in    STD_LOGIC;
      IN7                            :	in    STD_LOGIC;
      IN8                            :	in    STD_LOGIC;
      IN9                            :	in    STD_LOGIC);
end component;


----- Component AND10 -----
component AND10
   generic(
      TimingChecksOn: Boolean := DefaultTimingChecksOn;
      XGenerationOn: Boolean := DefaultXGenerationOn;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN2_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN3_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN4_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN5_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN6_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN7_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN8_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN9_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN10_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN2                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN3                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN4                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN5                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN6                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN7                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN8                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN9                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN10                      :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC;
      IN2                            :	in    STD_LOGIC;
      IN3                            :	in    STD_LOGIC;
      IN4                            :	in    STD_LOGIC;
      IN5                            :	in    STD_LOGIC;
      IN6                            :	in    STD_LOGIC;
      IN7                            :	in    STD_LOGIC;
      IN8                            :	in    STD_LOGIC;
      IN9                            :	in    STD_LOGIC;
      IN10                           :	in    STD_LOGIC);
end component;


----- Component AND11 -----
component AND11
   generic(
      TimingChecksOn: Boolean := DefaultTimingChecksOn;
      XGenerationOn: Boolean := DefaultXGenerationOn;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN2_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN3_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN4_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN5_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN6_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN7_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN8_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN9_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN10_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN11_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN2                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN3                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN4                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN5                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN6                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN7                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN8                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN9                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN10                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN11                      :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC;
      IN2                            :	in    STD_LOGIC;
      IN3                            :	in    STD_LOGIC;
      IN4                            :	in    STD_LOGIC;
      IN5                            :	in    STD_LOGIC;
      IN6                            :	in    STD_LOGIC;
      IN7                            :	in    STD_LOGIC;
      IN8                            :	in    STD_LOGIC;
      IN9                            :	in    STD_LOGIC;
      IN10                           :	in    STD_LOGIC;
      IN11                           :	in    STD_LOGIC);
end component;


----- Component AND12 -----
component AND12
   generic(
      TimingChecksOn: Boolean := DefaultTimingChecksOn;
      XGenerationOn: Boolean := DefaultXGenerationOn;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN2_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN3_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN4_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN5_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN6_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN7_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN8_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN9_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN10_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN11_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN12_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN2                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN3                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN4                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN5                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN6                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN7                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN8                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN9                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN10                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN11                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN12                      :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC;
      IN2                            :	in    STD_LOGIC;
      IN3                            :	in    STD_LOGIC;
      IN4                            :	in    STD_LOGIC;
      IN5                            :	in    STD_LOGIC;
      IN6                            :	in    STD_LOGIC;
      IN7                            :	in    STD_LOGIC;
      IN8                            :	in    STD_LOGIC;
      IN9                            :	in    STD_LOGIC;
      IN10                           :	in    STD_LOGIC;
      IN11                           :	in    STD_LOGIC;
      IN12                           :	in    STD_LOGIC);
end component;


----- Component AND13 -----
component AND13
   generic(
      TimingChecksOn: Boolean := DefaultTimingChecksOn;
      XGenerationOn: Boolean := DefaultXGenerationOn;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN2_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN3_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN4_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN5_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN6_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN7_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN8_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN9_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN10_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN11_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN12_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN13_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN2                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN3                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN4                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN5                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN6                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN7                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN8                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN9                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN10                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN11                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN12                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN13                      :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC;
      IN2                            :	in    STD_LOGIC;
      IN3                            :	in    STD_LOGIC;
      IN4                            :	in    STD_LOGIC;
      IN5                            :	in    STD_LOGIC;
      IN6                            :	in    STD_LOGIC;
      IN7                            :	in    STD_LOGIC;
      IN8                            :	in    STD_LOGIC;
      IN9                            :	in    STD_LOGIC;
      IN10                           :	in    STD_LOGIC;
      IN11                           :	in    STD_LOGIC;
      IN12                           :	in    STD_LOGIC;
      IN13                           :	in    STD_LOGIC);
end component;


----- Component AND14 -----
component AND14
   generic(
      TimingChecksOn: Boolean := DefaultTimingChecksOn;
      XGenerationOn: Boolean := DefaultXGenerationOn;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN2_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN3_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN4_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN5_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN6_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN7_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN8_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN9_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN10_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN11_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN12_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN13_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN14_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN2                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN3                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN4                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN5                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN6                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN7                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN8                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN9                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN10                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN11                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN12                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN13                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN14                      :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC;
      IN2                            :	in    STD_LOGIC;
      IN3                            :	in    STD_LOGIC;
      IN4                            :	in    STD_LOGIC;
      IN5                            :	in    STD_LOGIC;
      IN6                            :	in    STD_LOGIC;
      IN7                            :	in    STD_LOGIC;
      IN8                            :	in    STD_LOGIC;
      IN9                            :	in    STD_LOGIC;
      IN10                           :	in    STD_LOGIC;
      IN11                           :	in    STD_LOGIC;
      IN12                           :	in    STD_LOGIC;
      IN13                           :	in    STD_LOGIC;
      IN14                           :	in    STD_LOGIC);
end component;


----- Component AND15 -----
component AND15
   generic(
      TimingChecksOn: Boolean := DefaultTimingChecksOn;
      XGenerationOn: Boolean := DefaultXGenerationOn;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN2_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN3_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN4_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN5_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN6_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN7_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN8_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN9_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN10_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN11_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN12_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN13_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN14_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN15_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN2                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN3                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN4                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN5                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN6                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN7                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN8                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN9                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN10                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN11                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN12                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN13                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN14                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN15                      :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC;
      IN2                            :	in    STD_LOGIC;
      IN3                            :	in    STD_LOGIC;
      IN4                            :	in    STD_LOGIC;
      IN5                            :	in    STD_LOGIC;
      IN6                            :	in    STD_LOGIC;
      IN7                            :	in    STD_LOGIC;
      IN8                            :	in    STD_LOGIC;
      IN9                            :	in    STD_LOGIC;
      IN10                           :	in    STD_LOGIC;
      IN11                           :	in    STD_LOGIC;
      IN12                           :	in    STD_LOGIC;
      IN13                           :	in    STD_LOGIC;
      IN14                           :	in    STD_LOGIC;
      IN15                           :	in    STD_LOGIC);
end component;


----- Component AND16 -----
component AND16
   generic(
      TimingChecksOn: Boolean := DefaultTimingChecksOn;
      XGenerationOn: Boolean := DefaultXGenerationOn;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN2_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN3_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN4_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN5_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN6_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN7_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN8_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN9_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN10_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN11_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN12_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN13_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN14_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN15_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN16_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN2                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN3                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN4                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN5                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN6                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN7                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN8                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN9                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN10                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN11                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN12                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN13                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN14                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN15                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN16                      :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC;
      IN2                            :	in    STD_LOGIC;
      IN3                            :	in    STD_LOGIC;
      IN4                            :	in    STD_LOGIC;
      IN5                            :	in    STD_LOGIC;
      IN6                            :	in    STD_LOGIC;
      IN7                            :	in    STD_LOGIC;
      IN8                            :	in    STD_LOGIC;
      IN9                            :	in    STD_LOGIC;
      IN10                           :	in    STD_LOGIC;
      IN11                           :	in    STD_LOGIC;
      IN12                           :	in    STD_LOGIC;
      IN13                           :	in    STD_LOGIC;
      IN14                           :	in    STD_LOGIC;
      IN15                           :	in    STD_LOGIC;
      IN16                           :	in    STD_LOGIC);
end component;


----- Component DELAY -----
component DELAY
   generic(
      TimingChecksOn: Boolean := DefaultTimingChecksOn;
      XGenerationOn: Boolean := DefaultXGenerationOn;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC);
end component;


----- Component DFF -----
component DFF
   generic(
      TimingChecksOn: Boolean := DefaultTimingChecksOn;
      XGenerationOn: Boolean := DefaultXGenerationOn;
      InstancePath: STRING := "*";
      tpd_PRN_Q_negedge              :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_CLRN_Q_negedge             :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_CLK_Q_posedge              :	DelayType01 := (0.000 ns, 0.000 ns);
      tsetup_D_CLK_posedge           :	DelayTypeXX := 0.000 ns;
      tsetup_D_CLK_negedge           :	DelayTypeXX := 0.000 ns;
      thold_CLK_D_posedge            :	DelayTypeXX := 0.000 ns;
      thold_CLK_D_negedge            :	DelayTypeXX := 0.000 ns;
      tipd_D                         :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLRN                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_PRN                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Q                              :	out   STD_LOGIC;
      D                              :	in    STD_LOGIC;
      CLRN                           :	in    STD_LOGIC;
      PRN                            :	in    STD_LOGIC;
      CLK                            :	in    STD_LOGIC);
end component;


----- Component DFFE -----
component DFFE
   generic(
      TimingChecksOn: Boolean := DefaultTimingChecksOn;
      XGenerationOn: Boolean := DefaultXGenerationOn;
      InstancePath: STRING := "*";
      tpd_PRN_Q_negedge                :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_CLRN_Q_negedge             :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_CLK_Q_posedge              :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_ENA_Q                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tsetup_D_CLK_posedge           :	DelayTypeXX := 0.000 ns;
      tsetup_D_CLK_negedge           :	DelayTypeXX := 0.000 ns;
      thold_CLK_D_posedge            :	DelayTypeXX := 0.000 ns;
      thold_CLK_D_negedge            :	DelayTypeXX := 0.000 ns;
      tipd_D                         :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLRN                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_PRN                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_CLK                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_ENA                       :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Q                              :	out   STD_LOGIC;
      D                              :	in    STD_LOGIC;
      CLRN                           :	in    STD_LOGIC;
      PRN                            :	in    STD_LOGIC;
      CLK                            :	in    STD_LOGIC;
      ENA                            :	in    STD_LOGIC);
end component;


----- Component FILTER -----
component FILTER
   generic(
      TimingChecksOn: Boolean := DefaultTimingChecksOn;
      XGenerationOn: Boolean := DefaultXGenerationOn;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpw_IN1_posedge                :  DelayTypeXX := (0.000 ns);
      tpw_IN1_negedge                :  DelayTypeXX := (0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC);
end component;


----- Component INV -----
component INV
   generic(
      TimingChecksOn: Boolean := DefaultTimingChecksOn;
      XGenerationOn: Boolean := DefaultXGenerationOn;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC);
end component;


----- Component LATCH -----
component LATCH
   generic(
      TimingChecksOn: Boolean := DefaultTimingChecksOn;
      XGenerationOn: Boolean := DefaultXGenerationOn;
      InstancePath: STRING := "*";
      tpd_D_Q_posedge                :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_ENA_Q_posedge              :	DelayType01 := (0.000 ns, 0.000 ns);
      tsetup_D_ENA_posedge	     :	DelayTypeXX := 0.000 ns;
      tsetup_D_ENA_negedge	     :	DelayTypeXX := 0.000 ns;
      thold_ENA_D_posedge	     :	DelayTypeXX := 0.000 ns;
      thold_ENA_D_negedge	     :	DelayTypeXX := 0.000 ns;
      tipd_D                         :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_ENA                       :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Q                              :	out   STD_LOGIC;
      D                              :	in    STD_LOGIC;
      ENA                            :	in    STD_LOGIC);
end component;


----- Component OR1 -----
component OR1
   generic(
      TimingChecksOn: Boolean := DefaultTimingChecksOn;
      XGenerationOn: Boolean := DefaultXGenerationOn;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC);
end component;


----- Component OR2 -----
component OR2
   generic(
      TimingChecksOn: Boolean := DefaultTimingChecksOn;
      XGenerationOn: Boolean := DefaultXGenerationOn;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN2_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN2                       :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC;
      IN2                            :	in    STD_LOGIC);
end component;


----- Component OR3 -----
component OR3
   generic(
      TimingChecksOn: Boolean := DefaultTimingChecksOn;
      XGenerationOn: Boolean := DefaultXGenerationOn;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN2_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN3_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN2                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN3                       :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC;
      IN2                            :	in    STD_LOGIC;
      IN3                            :	in    STD_LOGIC);
end component;


----- Component OR4 -----
component OR4
   generic(
      TimingChecksOn: Boolean := DefaultTimingChecksOn;
      XGenerationOn: Boolean := DefaultXGenerationOn;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN2_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN3_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN4_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN2                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN3                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN4                       :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC;
      IN2                            :	in    STD_LOGIC;
      IN3                            :	in    STD_LOGIC;
      IN4                            :	in    STD_LOGIC);
end component;


----- Component OR5 -----
component OR5
   generic(
      TimingChecksOn: Boolean := DefaultTimingChecksOn;
      XGenerationOn: Boolean := DefaultXGenerationOn;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN2_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN3_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN4_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN5_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN2                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN3                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN4                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN5                       :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC;
      IN2                            :	in    STD_LOGIC;
      IN3                            :	in    STD_LOGIC;
      IN4                            :	in    STD_LOGIC;
      IN5                            :	in    STD_LOGIC);
end component;


----- Component OR6 -----
component OR6
   generic(
      TimingChecksOn: Boolean := DefaultTimingChecksOn;
      XGenerationOn: Boolean := DefaultXGenerationOn;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN2_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN3_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN4_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN5_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN6_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN2                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN3                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN4                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN5                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN6                       :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC;
      IN2                            :	in    STD_LOGIC;
      IN3                            :	in    STD_LOGIC;
      IN4                            :	in    STD_LOGIC;
      IN5                            :	in    STD_LOGIC;
      IN6                            :	in    STD_LOGIC);
end component;


----- Component OR7 -----
component OR7
   generic(
      TimingChecksOn: Boolean := DefaultTimingChecksOn;
      XGenerationOn: Boolean := DefaultXGenerationOn;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN2_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN3_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN4_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN5_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN6_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN7_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN2                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN3                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN4                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN5                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN6                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN7                       :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC;
      IN2                            :	in    STD_LOGIC;
      IN3                            :	in    STD_LOGIC;
      IN4                            :	in    STD_LOGIC;
      IN5                            :	in    STD_LOGIC;
      IN6                            :	in    STD_LOGIC;
      IN7                            :	in    STD_LOGIC);
end component;


----- Component OR8 -----
component OR8
   generic(
      TimingChecksOn: Boolean := DefaultTimingChecksOn;
      XGenerationOn: Boolean := DefaultXGenerationOn;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN2_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN3_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN4_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN5_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN6_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN7_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN8_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN2                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN3                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN4                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN5                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN6                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN7                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN8                       :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC;
      IN2                            :	in    STD_LOGIC;
      IN3                            :	in    STD_LOGIC;
      IN4                            :	in    STD_LOGIC;
      IN5                            :	in    STD_LOGIC;
      IN6                            :	in    STD_LOGIC;
      IN7                            :	in    STD_LOGIC;
      IN8                            :	in    STD_LOGIC);
end component;


----- Component OR9 -----
component OR9
   generic(
      TimingChecksOn: Boolean := DefaultTimingChecksOn;
      XGenerationOn: Boolean := DefaultXGenerationOn;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN2_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN3_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN4_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN5_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN6_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN7_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN8_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN9_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN2                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN3                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN4                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN5                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN6                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN7                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN8                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN9                       :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC;
      IN2                            :	in    STD_LOGIC;
      IN3                            :	in    STD_LOGIC;
      IN4                            :	in    STD_LOGIC;
      IN5                            :	in    STD_LOGIC;
      IN6                            :	in    STD_LOGIC;
      IN7                            :	in    STD_LOGIC;
      IN8                            :	in    STD_LOGIC;
      IN9                            :	in    STD_LOGIC);
end component;


----- Component OR10 -----
component OR10
   generic(
      TimingChecksOn: Boolean := DefaultTimingChecksOn;
      XGenerationOn: Boolean := DefaultXGenerationOn;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN2_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN3_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN4_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN5_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN6_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN7_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN8_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN9_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN10_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN2                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN3                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN4                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN5                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN6                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN7                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN8                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN9                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN10                      :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC;
      IN2                            :	in    STD_LOGIC;
      IN3                            :	in    STD_LOGIC;
      IN4                            :	in    STD_LOGIC;
      IN5                            :	in    STD_LOGIC;
      IN6                            :	in    STD_LOGIC;
      IN7                            :	in    STD_LOGIC;
      IN8                            :	in    STD_LOGIC;
      IN9                            :	in    STD_LOGIC;
      IN10                           :	in    STD_LOGIC);
end component;


----- Component OR11 -----
component OR11
   generic(
      TimingChecksOn: Boolean := DefaultTimingChecksOn;
      XGenerationOn: Boolean := DefaultXGenerationOn;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN2_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN3_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN4_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN5_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN6_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN7_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN8_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN9_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN10_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN11_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN2                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN3                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN4                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN5                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN6                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN7                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN8                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN9                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN10                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN11                      :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC;
      IN2                            :	in    STD_LOGIC;
      IN3                            :	in    STD_LOGIC;
      IN4                            :	in    STD_LOGIC;
      IN5                            :	in    STD_LOGIC;
      IN6                            :	in    STD_LOGIC;
      IN7                            :	in    STD_LOGIC;
      IN8                            :	in    STD_LOGIC;
      IN9                            :	in    STD_LOGIC;
      IN10                           :	in    STD_LOGIC;
      IN11                           :	in    STD_LOGIC);
end component;


----- Component OR12 -----
component OR12
   generic(
      TimingChecksOn: Boolean := DefaultTimingChecksOn;
      XGenerationOn: Boolean := DefaultXGenerationOn;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN2_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN3_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN4_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN5_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN6_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN7_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN8_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN9_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN10_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN11_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN12_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN2                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN3                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN4                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN5                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN6                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN7                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN8                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN9                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN10                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN11                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN12                      :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC;
      IN2                            :	in    STD_LOGIC;
      IN3                            :	in    STD_LOGIC;
      IN4                            :	in    STD_LOGIC;
      IN5                            :	in    STD_LOGIC;
      IN6                            :	in    STD_LOGIC;
      IN7                            :	in    STD_LOGIC;
      IN8                            :	in    STD_LOGIC;
      IN9                            :	in    STD_LOGIC;
      IN10                           :	in    STD_LOGIC;
      IN11                           :	in    STD_LOGIC;
      IN12                           :	in    STD_LOGIC);
end component;


----- Component OR13 -----
component OR13
   generic(
      TimingChecksOn: Boolean := DefaultTimingChecksOn;
      XGenerationOn: Boolean := DefaultXGenerationOn;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN2_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN3_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN4_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN5_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN6_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN7_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN8_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN9_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN10_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN11_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN12_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN13_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN2                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN3                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN4                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN5                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN6                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN7                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN8                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN9                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN10                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN11                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN12                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN13                      :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC;
      IN2                            :	in    STD_LOGIC;
      IN3                            :	in    STD_LOGIC;
      IN4                            :	in    STD_LOGIC;
      IN5                            :	in    STD_LOGIC;
      IN6                            :	in    STD_LOGIC;
      IN7                            :	in    STD_LOGIC;
      IN8                            :	in    STD_LOGIC;
      IN9                            :	in    STD_LOGIC;
      IN10                           :	in    STD_LOGIC;
      IN11                           :	in    STD_LOGIC;
      IN12                           :	in    STD_LOGIC;
      IN13                           :	in    STD_LOGIC);
end component;


----- Component OR14 -----
component OR14
   generic(
      TimingChecksOn: Boolean := DefaultTimingChecksOn;
      XGenerationOn: Boolean := DefaultXGenerationOn;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN2_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN3_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN4_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN5_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN6_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN7_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN8_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN9_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN10_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN11_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN12_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN13_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN14_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN2                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN3                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN4                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN5                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN6                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN7                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN8                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN9                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN10                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN11                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN12                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN13                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN14                      :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC;
      IN2                            :	in    STD_LOGIC;
      IN3                            :	in    STD_LOGIC;
      IN4                            :	in    STD_LOGIC;
      IN5                            :	in    STD_LOGIC;
      IN6                            :	in    STD_LOGIC;
      IN7                            :	in    STD_LOGIC;
      IN8                            :	in    STD_LOGIC;
      IN9                            :	in    STD_LOGIC;
      IN10                           :	in    STD_LOGIC;
      IN11                           :	in    STD_LOGIC;
      IN12                           :	in    STD_LOGIC;
      IN13                           :	in    STD_LOGIC;
      IN14                           :	in    STD_LOGIC);
end component;


----- Component OR15 -----
component OR15
   generic(
      TimingChecksOn: Boolean := DefaultTimingChecksOn;
      XGenerationOn: Boolean := DefaultXGenerationOn;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN2_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN3_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN4_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN5_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN6_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN7_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN8_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN9_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN10_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN11_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN12_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN13_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN14_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN15_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN2                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN3                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN4                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN5                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN6                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN7                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN8                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN9                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN10                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN11                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN12                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN13                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN14                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN15                      :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC;
      IN2                            :	in    STD_LOGIC;
      IN3                            :	in    STD_LOGIC;
      IN4                            :	in    STD_LOGIC;
      IN5                            :	in    STD_LOGIC;
      IN6                            :	in    STD_LOGIC;
      IN7                            :	in    STD_LOGIC;
      IN8                            :	in    STD_LOGIC;
      IN9                            :	in    STD_LOGIC;
      IN10                           :	in    STD_LOGIC;
      IN11                           :	in    STD_LOGIC;
      IN12                           :	in    STD_LOGIC;
      IN13                           :	in    STD_LOGIC;
      IN14                           :	in    STD_LOGIC;
      IN15                           :	in    STD_LOGIC);
end component;


----- Component OR16 -----
component OR16
   generic(
      TimingChecksOn: Boolean := DefaultTimingChecksOn;
      XGenerationOn: Boolean := DefaultXGenerationOn;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN2_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN3_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN4_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN5_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN6_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN7_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN8_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN9_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN10_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN11_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN12_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN13_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN14_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN15_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN16_Y                     :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN2                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN3                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN4                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN5                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN6                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN7                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN8                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN9                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN10                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN11                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN12                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN13                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN14                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN15                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN16                      :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC;
      IN2                            :	in    STD_LOGIC;
      IN3                            :	in    STD_LOGIC;
      IN4                            :	in    STD_LOGIC;
      IN5                            :	in    STD_LOGIC;
      IN6                            :	in    STD_LOGIC;
      IN7                            :	in    STD_LOGIC;
      IN8                            :	in    STD_LOGIC;
      IN9                            :	in    STD_LOGIC;
      IN10                           :	in    STD_LOGIC;
      IN11                           :	in    STD_LOGIC;
      IN12                           :	in    STD_LOGIC;
      IN13                           :	in    STD_LOGIC;
      IN14                           :	in    STD_LOGIC;
      IN15                           :	in    STD_LOGIC;
      IN16                           :	in    STD_LOGIC);
end component;


----- Component RISEFALL -----
component RISEFALL
   generic(
      TimingChecksOn: Boolean := DefaultTimingChecksOn;
      XGenerationOn: Boolean := DefaultXGenerationOn;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :  DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :  DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :  out   STD_LOGIC;
      IN1                            :  in    STD_LOGIC);
end component;


----- Component TRIBUF -----
component TRIBUF
   generic(
      TimingChecksOn: Boolean := DefaultTimingChecksOn;
      XGenerationOn: Boolean := DefaultXGenerationOn;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_OE_Y                       :	DelayType01z := 
               (0.000 ns, 0.000 ns, 0.000 ns, 0.000 ns, 0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_OE                        :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC;
      OE                             :	in    STD_LOGIC);
end component;


----- Component XOR2 -----
component XOR2
   generic(
      TimingChecksOn: Boolean := DefaultTimingChecksOn;
      XGenerationOn: Boolean := DefaultXGenerationOn;
      InstancePath: STRING := "*";
      tpd_IN1_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tpd_IN2_Y                      :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN1                       :	DelayType01 := (0.000 ns, 0.000 ns);
      tipd_IN2                       :	DelayType01 := (0.000 ns, 0.000 ns));

   port(
      Y                              :	out   STD_LOGIC;
      IN1                            :	in    STD_LOGIC;
      IN2                            :	in    STD_LOGIC);
end component;


end VCOMPONENTS;